<?php
// Include necessary files and configurations
include 'services/session.php';

// Include database connection file
include('includes/dbconn.php');
function generateInvoiceNumber($conn) {
    $prefix = "FAS-";

    // Lock the counter to ensure atomicity in case of simultaneous requests
    $conn->query("LOCK TABLES counter WRITE, invoices READ");

    // Get the current counter value or initialize if the table is empty
    $result = $conn->query("SELECT counter_value FROM counter");

    // Check for query execution errors
    if (!$result) {
        die("Error fetching counter value: " . $conn->error);
    }

    // Check if there are any rows
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $counter_value = $row['counter_value'];
    } else {
        // No rows returned, initialize with a default value
        $counter_value = 1;

        // Insert a new row with the default value and an empty generated_invoice_number
        $conn->query("INSERT INTO counter (counter_value, generated_invoice_number) VALUES ($counter_value, '')");

        // Note: You may want to handle the case where the insert fails as well
    }

    // Generate a padded invoice number (e.g., FAS-000001)
    $invoice_number = $prefix . str_pad($counter_value, 6, '0', STR_PAD_LEFT);

    // Check if the generated number already exists in the invoices table
    $checkQuery = "SELECT * FROM invoices WHERE invoice_number = '$invoice_number'";
    $result = $conn->query($checkQuery);

    // If the number exists, regenerate
    while ($result->num_rows > 0) {
        $counter_value++;
        $invoice_number = $prefix . str_pad($counter_value, 6, '0', STR_PAD_LEFT);

        // Check again
        $result = $conn->query("SELECT * FROM invoices WHERE invoice_number = '$invoice_number'");
    }

    // Increment the counter value and update the counter table
    $conn->query("UPDATE counter SET counter_value = $counter_value, generated_invoice_number = '$invoice_number'");

    // Unlock the counter
    $conn->query("UNLOCK TABLES");

    return $invoice_number;
}

?>

<!DOCTYPE html>
<html lang="en">

<head>

    <?php
    $title = "Create Client Invoice";
    include 'partials/title-meta.php';
    ?>

    <link href="assets/libs/mohithg-switchery/switchery.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/multiselect/css/multi-select.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/select2/css/select2.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/selectize/css/selectize.bootstrap3.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet" type="text/css" />

    <?php
    include 'partials/head-css.php';
    ?>

</head>

<?php
include 'partials/body.php';
?>

<!-- Begin page -->
<div id="wrapper">

    <?php
    $pagetitle = "Edit Client Invoice";
    include 'partials/menu.php';
    ?>

    <!-- ============================================================== -->
    <!-- Start Page Content here -->
    <!-- ============================================================== -->

    <div class="content-page">
        <div class="content">

            <!-- Start Content-->
            <div class="container-fluid">

                <div class="card">
                    <div class="card-body">
                        <h4 class="header-title">Edit Client Invoice</h4>
                        <p class="sub-header">Edit client invoice.</p>

                        <form action="edit_invoice.php?id=<?php echo htmlspecialchars($invoiceId); ?>" method="post">
                            <label for="client_id">Client ID:</label>
                            <input type="text" id="client_id" name="client_id" value="<?php echo htmlspecialchars($invoice['client_id']); ?>" required><br>
                    
                            <label for="total_amount">Total Amount:</label>
                            <input type="number" step="0.01" id="total_amount" name="total_amount" value="<?php echo htmlspecialchars($invoice['total_amount']); ?>" required><br>
                    
                            <label for="due_date">Due Date:</label>
                            <input type="date" id="due_date" name="due_date" value="<?php echo htmlspecialchars($invoice['due_date']); ?>" required><br>
                    
                            <label for="description" class="form-label">Description</label>
                            <input type="text" id="description" name="description" value="<?php echo htmlspecialchars($invoice['description']); ?>" required><br>
                    
                            <label for="quantity" class="form-label">Quantity</label>
                            <input type="number" step="0.01" id="quantity" name="quantity" value="<?php echo htmlspecialchars($invoice['quantity']); ?>" required><br>
                    
                            <label for="unit_price" class="form-label">Unit Price</label>
                            <input type="number" step="0.01" id="unit_price" name="unit_price" value="<?php echo htmlspecialchars($invoice['unit_price']); ?>" required><br>
                    
                            <!-- Add more fields as necessary -->
                    
                            <button type="submit">Update Invoice</button>
                        </form>

                    </div> <!-- end card-body-->
                </div> <!-- end card-->

            </div> <!-- container -->

        </div> <!-- content -->

        <?php
        include 'partials/footer.php';
        ?>

    </div>

    <!-- ============================================================== -->
    <!-- End Page content -->
    <!-- ============================================================== -->

</div>
<!-- END wrapper -->

<?php
include 'partials/right-sidebar.php';
?>

<?php
include 'partials/footer-scripts.php';
?>

<!-- Plugin js-->
<script src="assets/libs/parsleyjs/parsley.min.js"></script>

<!-- Validation init js-->
<script src="assets/js/pages/form-validation.init.js"></script>

<!-- App js -->
<script src="assets/js/app.min.js"></script>
<script src="assets/libs/selectize/js/standalone/selectize.min.js"></script>
<script src="assets/libs/mohithg-switchery/switchery.min.js"></script>
<script src="assets/libs/multiselect/js/jquery.multi-select.js"></script>
<script src="assets/libs/select2/js/select2.min.js"></script>
<script src="assets/libs/jquery-mockjax/jquery.mockjax.min.js"></script>
<script src="assets/libs/devbridge-autocomplete/jquery.autocomplete.min.js"></script>
<script src="assets/libs/bootstrap-touchspin/jquery.bootstrap-touchspin.min.js"></script>
<script src="assets/libs/bootstrap-maxlength/bootstrap-maxlength.min.js"></script>
<script>
    $(document).ready(function() {
        $('#client_name').select2();
    });
</script>
<script>
    // Get today's date
    var today = new Date();

    // Format it as YYYY-MM-DD (which is the format commonly used in databases)
    var formattedDate = today.toISOString().substr(0, 10);

    // Set the default value of the input field to today's date
    document.getElementById("start_date").value = formattedDate;
</script>

</body>

</html>
